﻿<%@ Page Language="C#" AutoEventWireup="false" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Handel.Forms" %>
<%@ Import Namespace="Soneta.Handel.Config" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System.Collections.ObjectModel" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <title>Raport sprzedaży wgo dokumentów i magazynów</title>
    <script runat="server">
    	
		public sealed class DataRepeaterRow
		{
			private readonly Magazyn _magazyn;

			private readonly Parameters _params;

			public IEnumerable<DataRow> DataRows
			{
				get
				{
					var module = Magazyn.Module.Handel;
					var doks = module.DokHandlowe.WgDefinicja.CreateView();
				    doks.Condition &= new FieldCondition.In("Stan", StanDokumentuHandlowego.Zatwierdzony, StanDokumentuHandlowego.Zablokowany)
				                      & new FieldCondition.Equal("Magazyn", Magazyn)
				                      & new FieldCondition.Contain("Data", Okres)
				                      & new FieldCondition.In("Kategoria", KategoriaHandlowa.Sprzedaż, KategoriaHandlowa.KorektaSprzedaży)
				                      & new FieldCondition.Equal("KierunekMagazynu", KierunekPartii.Rozchód);

					var rows = new DictionaryZero<DokumentHandlowy,DataRow>();				
					foreach (DokumentHandlowy dok in doks)
						foreach(PozycjaDokHandlowego poz in dok.Pozycje)
						{
								var key = dok;
								var row = rows[key, () => new DataRow(key)];
								row += poz;
								rows[key] = row;
						}
					return rows.Values;
				}
			}

		    public Magazyn Magazyn
		    {
		        get { return _magazyn; }
		    }

		    public FromTo Okres
		    {
		        get { return _params.Okres; }
		    }

		    public DataRepeaterRow(Magazyn magazyn, Parameters @params)
			{
				_magazyn = magazyn;
				_params = @params;
			}

		}
    	
    	public sealed class DataRow
		{
			private readonly DokumentHandlowy _key;
			private readonly IlośćWartość[] _iloscWartosc = new IlośćWartość[1];
			private readonly IlośćWartość[] _iloscWartoscKorekta = new IlośćWartość[1];

			public DokumentHandlowy Dokument
			{
				get { return _key; }
			}

	        public int Count
	        {
	            get { return 1; }
	        }

	        public Quantity RozchodIlosc
	        {
	            get { return _iloscWartosc[0].Ilość; }
	        }

	        public Currency RozchodWartosc
	        {
	            get { return _iloscWartosc[0].Wartość; }
	        }

	        public Currency RozchodWartoscKorekta
	        {
	            get { return _iloscWartoscKorekta[0].Wartość; }
	        }

	        public DataRow(DokumentHandlowy key)
			{
				_key = key;
			}

			public static DataRow operator +(DataRow row, PozycjaDokHandlowego pozycja)
			{
			    var wartość = pozycja.Dokument.PrzeliczWgKursu(pozycja.Suma.NettoCy, "PLN");
				if (pozycja.Dokument == row._key)
				{
                        var jestKWPZ = row._key.Nadrzędne[TypRelacjiHandlowej.KorektaPWZ] != null;
                        row._iloscWartosc[0] += new IlośćWartość(jestKWPZ ? Quantity.Zero : new Quantity(pozycja.ZmianaIlości.Value, "szt"), wartość);
                        row._iloscWartoscKorekta[0] += new IlośćWartość(Quantity.Zero, pozycja.ZmianaNetto);


				}
				return row;
			}
		}

		public sealed class Parameters : ContextBase
		{
			private Magazyn[] _magazyny;
			
			private FromTo _okres;

		    [Priority(10)]
		    [Caption("Magazyny")]
		    [DefaultWidth(22)]
		    public Magazyn[] Magazyny
		    {
		        get { return _magazyny; }
		        set
		        {
		            _magazyny = value;
		            OnChanged(EventArgs.Empty);
		        }
		    }

		    [Priority(20)]
		    [Caption("Okres")]
		    [DefaultWidth(22)]
		    public FromTo Okres
		    {
		        get { return _okres; }
		        set
		        {
		            _okres = value;
		            OnChanged(EventArgs.Empty);
		        }
		    }

		    public Parameters(Context context)
				: base(context)
			{
				FromTo ft;
				Magazyn m;
				OkresMagazynowy om;
				DokumentyParams dp;
				DokHandloweViewInfo.WParams wp;
				var uh = context != null ? new UstawieniaHandloweWorker(context.Session) : null;
				if (context != null && context.Get(out wp))
				{
					_okres = wp.Okres;
				}	
				else if (context != null && context.Get(out dp))
				{
					_okres = dp.OkresDat;
				}
				else if (context != null && context.Get(out om))
				{
					_okres = om.Okres;
				}
				else if (context != null && context.Get(out ft))
				{
					_okres = ft;
				}
				else
				{
					_okres = Date.Today.ToYearMonth().ToFromTo();
				}
				if (context != null && context.Get(out wp) && wp.Magazyn != null)
				{
					_magazyny = new[] { wp.Magazyn };
				}
				else if (context != null && context.Get(out m) && m != null)
				{
					_magazyny = new[] { m };
				}
				else if (uh != null && uh.StandardowyMagazyn != null)
				{
					_magazyny = new[] { new UstawieniaHandloweWorker(context.Session).StandardowyMagazyn };
				}
				else if (context != null)
				{
					var module = MagazynyModule.GetInstance(context);
					_magazyny = new List<Row>(module.Magazyny.GetGrantedView()).ConvertAll(row => (Magazyn) row).ToArray();
				}
			}
		}

		private Parameters _params;

        [Context]
        public Parameters Params
        {
            get { return _params; }
            set { _params = value; }
        }

        private void dc_ContextLoad(object sender, EventArgs e)
		{
			var dc = sender as DataContext;
		    if (dc == null) return;

		    _dataRepeater.DataSource = new List<Row>(_params.Magazyny).ConvertAll(row => new DataRepeaterRow((Magazyn) row, _params));
		}

		private void dr_BeforeRow(object sender, EventArgs e)
		{			
			var dr = sender as DataRepeater;
			var row = dr != null ? dr.CurrentRow as DataRepeaterRow : null;			
			_dataGrid.DataSource = row != null ? row.DataRows : new DataRow[0];
		}
    	
    </script>
</head>
<body>
	<form runat="server" method="post">
		<ea:DataContext runat="server" 
			OnContextLoad="dc_ContextLoad" />
		<ea:DataRepeater runat="server" ID="_dataRepeater" WithSections="true" OnBeforeRow="dr_BeforeRow" RowTypeName="DataRepeaterRow,.">
			<ea:PageBreak runat="server" BreakFirstTimes="false" ResetPageCounter="true"  ></ea:PageBreak>
			<eb:ReportHeader runat="server" FirstHeader="true" WithSections="true" Title="Raport sprzedaży wg dokumentów"></eb:ReportHeader>
			<ea:Section runat="server">
				<div style="font-family: Tahoma, Sans-Serif;"> <div style="border: none; font-size: 13px;">
						Magazyn: <ea:DataLabel runat="server" DataMember="Magazyn"></ea:DataLabel>,
						Okres: <ea:DataLabel runat="server" DataMember="Okres"></ea:DataLabel>.					
					</div>
					<ea:Grid runat="server" ID="_dataGrid" RowTypeName="DataRow,." GroupLine="{0}" ShowGroupSum="true" GroupData0="Dokument.Definicja">
						<Columns>
							<ea:GridColumn runat="server" Caption="Dokument" DataMember="Dokument" Align="Left"></ea:GridColumn>
							<ea:GridColumn runat="server" Caption="Ilość dok." DataMember="Count" Align="Right" Total="Sum" Width="12"></ea:GridColumn>
							<ea:GridColumn runat="server" Caption="Data~dokumentu" DataMember="Dokument.Data" Align="Center" Width="12"></ea:GridColumn>
							<ea:GridColumn runat="server" Caption="Data~operacji" DataMember="Dokument.DataOperacji" Align="Center" Width="12"></ea:GridColumn>
						    <ea:GridColumn runat="server" Caption="Ilość tow. (bez jedn.)" DataMember="RozchodIlosc.Value" Align="Right" Total="Sum" HideZero="False" Width="12"></ea:GridColumn>
							<ea:GridColumn runat="server" Caption="Wartość końcowa" DataMember="RozchodWartosc" Align="Right" Total="Sum" HideZero="False"></ea:GridColumn>
							<ea:GridColumn runat="server" Caption="Wartość" DataMember="RozchodWartoscKorekta" Align="Right" Total="Sum" HideZero="False"></ea:GridColumn>
						</Columns>
					</ea:Grid>
				</div>
			</ea:Section>
		</ea:DataRepeater>
	</form>
</body>
</html>
